﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="CCOWTest.aspx.cs" Inherits="CCOWTest" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>CCOW Test</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <script type="text/javascript" language="javascript">
        var sentillionDesc = "<% Response.Write(SentillionReasonDesc); %>";
        var sentillionCode = "<% Response.Write(SentillionReasonCode); %>";
        var contextDesc = "<% Response.Write(ContextReasonDesc); %>";
        var contextCode = "<% Response.Write(ContextReasonCode); %>";
    </script>


<object id="ContextorControl" data="data:application/x-oleobject;base64,96x4h6lc0xGHJwBgsLXhNwADAADYEwAA2BMAAA=="
	classid="CLSID:8778ACF7-5CA9-11D3-8727-0060B0B5E137" name="ContextorControl" >
</object>

<script type="text/javascript" language="JavaScript" for="window" event="onLoad()">
    startSentillion();
</script>

<script type="text/javascript" language="javascript">

    var foundID = null;

    function startSentillion() {
        addToDisplay("***Initializing Single Sign-On***", "");
        addToDisplay("Attempting to bind to user context...", "");
        //Give the UI thread time to draw the screen, then actually startup Sentillion.
        setTimeout(delayedStartSentillion, 100);
    }

    function delayedStartSentillion() {
        appcode = ""
        appname = "CCOWDisplayer#"
        surveyable = true;
        try {
            ContextorControl.Run(appname, appcode, surveyable);
        } catch (errorObject) {
            //The Sentillion components were not found. Show an error and the site selection box.
            addToDisplay("Sentillion Components", sentillionDesc);
            //addToDisplay("Please wait...", "");
            return;
        }
        processContext(ContextorControl.CurrentContext);
    }

    function addToDisplay(key, value) {
        var row = logTable.insertRow(logTable.rows.length);
        var cell = row.insertCell(0);
        cell.innerHTML = key;
        if (value != null && value.length > 0) {
            addToDisplay(value, "");
        }
    }

    function processContext(contextItems) {
        try {
            var coll = new Enumerator(contextItems);
            if (coll.atEnd()) {
                //The Sentillion components were found but there is no context.
                addToDisplay("No Context Found", "");
                addToDisplay("Please login to CPRS to complete the test.", "Once CPRS has launched, click the refresh button to reload this page.");
                LogNoContextFound();
                return;
            }
            //The Sentillion components were found and there is context.
            for (; !coll.atEnd() ; coll.moveNext()) {
                var itemName = coll.item().name;
                var itemValue = coll.item().value;
                if (itemName == "user.id.logon.vistalogon") {
                    //We have everything we need to test the user credentials.
                    addToDisplay("Login found", "");
                    foundID = itemValue;
                    var s = new String(foundID);
                    var index = s.indexOf("^", 0);
                    if (index == -1) {
                        addToDisplay("Unable to determine division", foundID);
                    }
                    else {
                        addToDisplay("The following station division will be uesd to access VistALink", s.substring(index + 1))
                    }
                    //todo: extract the station division
                    //return;
                }
                if (itemName == "user.id.logon.vistaname") {
                    addToDisplay("Found the following user in the shared context", itemValue);
                }
            }
            if (null == foundID) {
                //The Sentillion components were found but the field we need was not found in the context. Show the station selection box.
                addToDisplay("Login not found", contextDesc);
            }
        } catch (errorObject) {
            addToDisplay(errorObject.message, errorObject.description);
        }
    }

    function GetBaseLocation() {
        var loc = new String(window.location);
        var found = loc.indexOf('?', 0);
        if (found > 0)
            loc = loc.substring(0, found - 1);
        found = loc.indexOf('#');
        if (found > 0)
            loc = loc.substring(0, found - 1);
        return loc;
    }

    function LogNoContextFound() {
        try {
            var loc = GetBaseLocation();
            var req = new XMLHttpRequest();
            req.open("POST", loc);
            req.setRequestHeader("Content-Type", "text/plain;charset=UTF-8");
            req.send("Error: No Context Found");
        }
        catch (x) {
            //if it doesn't make it to the log there's not much we can do - already displaying error to user
        }
    }

    function ContinueToApplication() {
        //var loc = GetBaseLocation();
        //window.navigate(window.location + "?" + actionQueryField + "=" + action + "&" + vistaQueryField + "=" + foundID + "&" + reasonQueryField + "=" + reason);
    }
</script>

</head>

<body>
    <form id="form1" runat="server">
    <div>
        <table id="logTable" style="max-width: 800px; margin-left: auto; margin-right: auto; margin-top: auto; margin-bottom: auto;text-align:center;">
            <tr>
                <td>
                    <h2 style="text-align: center;">Running CCOW Diagnostics</h2>
                </td>
            </tr>
            <tr>
                <td>
                    <h3 style="text-align: center;">Status</h3>
                </td>
            </tr>
        </table>
    </div>
    </form>
</body>
</html>
